﻿//+------------------------------------------------------------------+
//|                                       Probabilistic Forecast.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 0
#property indicator_plots   0

struct _stat {int a[][2];int size;};
_stat array[];
int price[],size=3,period,counter=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   size=MathMax(1,size);
   ArrayResize(array,size);
   for(int i=0;i<size;i++)
     {
      array[i].size=1;
      ArrayResize(array[i].a,1);
      ArrayInitialize(array[i].a,0);
     }

   period=size+1;
   ArrayResize(price,period);

   ArrowCreate("price_dn",clrRed);
   ArrowCreate("price_me",clrGreen);
   ArrowCreate("price_up",clrBlue);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   ObjectsDeleteAll(0,"price");
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(time,true);
      ArraySetAsSeries(open,true);

      int bars=rates_total-prev_calculated-1;
      if(prev_calculated==0)
        {
         bars=rates_total-period-1;
         for(int i=rates_total-1;i>bars;i--)
            ShiftPrice(open[i]);
        }

      for(int i=bars;i>=0;i--)
        {
         ShiftPrice(open[i]);

         for(int j=0;j<size;j++)
            Statistic(array[j].a,array[j].size,Difference(j));

         counter++;

         if(i==0)
           {
            int max=array[0].a[array[0].size-1][0]+price[0],min=array[0].a[0][0]+price[0];

            /*если вы хотите предусмотреть черных лебедей,
            то нужно искать макимальный максимум и минимальный минимум*/

            max=MathMin(max,array[1].a[array[1].size-1][0]+2*price[0]-price[1]);
            min=MathMax(min,array[1].a[0][0]+2*price[0]-price[1]);

            max=MathMin(max,array[2].a[array[2].size-1][0]+3*price[0]-3*price[1]+price[2]);
            min=MathMax(min,array[2].a[0][0]+3*price[0]-3*price[1]+price[2]);

            MaxMin(array[0].a,array[0].size,max,min);
            MaxMin(array[1].a,array[1].size,max,min);
            MaxMin(array[2].a,array[2].size,max,min);

            int s=max-min+1;
            datetime t=time[0]+PeriodSeconds();
            double prob[],shift=1./s;
            ArrayResize(prob,s);
            ArrayInitialize(prob,1);

            for(int d=0;d<size;d++)
               for(int j=0,k=ArrayBsearch(array[d].a,min);j<s;j++,k++)
                  prob[j]=prob[j]*((double)array[d].a[k][1]/counter+shift);

            double num=0,denom=0;
            for(int j=0;j<s;j++)
              {
               num=num+(min+j)*prob[j];
               denom=denom+prob[j];
              }
            ObjectMove(0,"price_me",0,t,NormalizeDouble(_Point*num/denom,_Digits));//матожидание цены

            int lim=(int)MathRound(num/denom)-min;
            num=0;
            denom=0;
            for(int j=0;j<lim;j++)
              {
               num=num+(min+j)*prob[j];
               denom=denom+prob[j];
              }
            ObjectMove(0,"price_dn",0,t,NormalizeDouble(_Point*num/denom,_Digits));//матожидание цены вниз

            num=0;
            denom=0;
            for(int j=lim;j<s;j++)
              {
               num=num+(min+j)*prob[j];
               denom=denom+prob[j];
              }
            ObjectMove(0,"price_up",0,t,NormalizeDouble(_Point*num/denom,_Digits));//матожидание цены вверх

            ChartRedraw();
           }
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void MaxMin(int &a[][2],int &s,int max,int min)
  {
//---
   if(max>a[s-1][0])
     {
      int news=max-a[0][0]+1;
      ArrayResize(a,news);
      for(int i=s;i<news;i++)
        {
         a[i][0]=a[0][0]+i;
         a[i][1]=0;
        }
      s=news;
     }

   if(min<a[0][0])
     {
      int b[][2],news=a[s-1][0]-min+1;
      ArrayResize(b,news);
      for(int i=0,j=0;i<news;i++)
        {
         b[i][0]=min+i;
         if(b[i][0]==a[j][0])
           {
            b[i][1]=a[j][1];
            j++;
           }
         else
            b[i][1]=0;
        }
      ArrayCopy(a,b);
      ArrayFree(b);
      s=news;
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void Statistic(int &a[][2],int &s,int d)
  {
//---
   if(d>a[s-1][0])
     {
      int news=d-a[0][0]+1;
      ArrayResize(a,news);
      for(int i=s;i<news;i++)
        {
         a[i][0]=a[0][0]+i;
         a[i][1]=0;
        }
      s=news;
     }

   if(d<a[0][0])
     {
      int b[][2],news=a[s-1][0]-d+1;
      ArrayResize(b,news);
      for(int i=0,j=0;i<news;i++)
        {
         b[i][0]=d+i;
         if(b[i][0]==a[j][0])
           {
            b[i][1]=a[j][1];
            j++;
           }
         else
            b[i][1]=0;
        }
      ArrayCopy(a,b);
      ArrayFree(b);
      s=news;
     }

   int i=ArrayBsearch(a,d);
   a[i][1]++;
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Difference(int j)
  {
//---
   if(j==0)
      return(price[0]-price[1]);
   if(j==1)
      return(price[0]-2*price[1]+price[2]);
   return(price[0]-3*price[1]+3*price[2]-price[3]);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ShiftPrice(double open)
  {
//---
   for(int i=period-1;i>0;i--)
      price[i]=price[i-1];
   price[0]=(int)MathRound(open/_Point);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ArrowCreate(string name,color clr)
  {
//---
   ObjectCreate(0,name,OBJ_ARROW_RIGHT_PRICE,0,0,0);
   ObjectSetInteger(0,name,OBJPROP_COLOR,clr);
//---
  }
//+------------------------------------------------------------------+
